-- Author  : John D P Purba
-- Purpose : Blok Register Output

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE WORK.enkrip_pack.ALL;

ENTITY BlokOutput IS
	PORT(clock_i  : IN std_logic;
		 reset_i  : IN std_logic;
		 
		 en_i	  : IN std_logic;
		 data_i   : IN bit128;
		 data_o   : OUT bit32;
		 valid_o  : OUT std_logic
	);
END BlokOutput;

ARCHITECTURE Struktur OF BlokOutput IS

COMPONENT Reg32o IS
	PORT(clock_i : IN std_logic;
		 reset_i : IN std_logic;

		 en_i	 : IN std_logic;
		 data_i	 : IN bit32;
		 data_o  : OUT bit32;
		 valid_o : OUT std_logic
	);
END COMPONENT;

COMPONENT Reg32o2in IS
	PORT(clock_i : IN std_logic;
		 reset_i : IN std_logic;

		 en_i	 : IN std_logic;
		 valid_i : IN std_logic;
		 data1_i : IN bit32;
		 data2_i : IN bit32;
		 data_o  : OUT bit32;
		 valid_o : OUT std_logic
	);
END COMPONENT;



SIGNAL sig_out1	: bit32;
SIGNAL sig_out2	: bit32;
SIGNAL sig_out3	: bit32;
SIGNAL sig_out4	: bit32;
SIGNAL sig_done1 : std_logic;
SIGNAL sig_done2 : std_logic;
SIGNAL sig_done3 : std_logic;
SIGNAL sig_done4 : std_logic;

BEGIN 


Rego1 : Reg32o PORT MAP(clock_i, reset_i, en_i, data_i(31 DOWNTO 0), sig_out1, sig_done1);

Rego2 : Reg32o2in PORT MAP(clock_i, reset_i, en_i, sig_done1, data_i(63 DOWNTO 32), sig_out1, sig_out2, sig_done2);

Rego3 : Reg32o2in PORT MAP(clock_i, reset_i, en_i, sig_done2, data_i(95 DOWNTO 64), sig_out2, sig_out3, sig_done3);

Rego4 : Reg32o2in PORT MAP(clock_i, reset_i, en_i, sig_done3, data_i(127 DOWNTO 96), sig_out3, data_o, valid_o);


END Struktur;







